<?php
include 'ser.php';
$config = include 'config.php';
$expiration_config = include 'expiration_config.php';

if ($expiration_config && isset($expiration_config['expiration_datetime'])) {
    $expiration_date_str = $expiration_config['expiration_datetime'];

    if (!empty($expiration_date_str)) {
        $expiration_datetime = new DateTime($expiration_date_str);
        $current_time = new DateTime();

        if ($current_time > $expiration_datetime) {
            header('Location: exp.php');
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>PANEL YOSLOMBOK 🍃</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.8)), url('https://i.ibb.co.com/wF8tS32F/IMG-20260120-WA0191.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            padding-bottom: 50px;
        }

        /* Navigasi Ganti Jadi Nomor WA */
        .nav-contact {
            margin: 20px 0;
            text-align: center;
        }

        .btn-wa-nav {
            background: rgba(56, 239, 125, 0.15);
            backdrop-filter: blur(10px);
            border: 1px solid #38ef7d;
            color: #38ef7d !important;
            padding: 12px 25px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: 0.3s;
            text-decoration: none !important;
            display: inline-block;
            box-shadow: 0 0 15px rgba(56, 239, 125, 0.2);
        }

        .btn-wa-nav:hover {
            background: #38ef7d;
            color: #000 !important;
            box-shadow: 0 0 25px rgba(56, 239, 125, 0.5);
            transform: translateY(-2px);
        }

        /* Glass Card */
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            padding: 25px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 20px;
            border-left: 4px solid #38ef7d;
            padding-left: 10px;
            text-align: left;
        }

        .form-control {
            background: rgba(0, 0, 0, 0.3) !important;
            border: 1px solid rgba(255, 255, 255, 0.1);
            color: #fff !important;
            border-radius: 10px;
            height: 45px;
        }

        .btn-custom {
            background: linear-gradient(45deg, #11998e, #38ef7d);
            border: none;
            color: #000;
            font-weight: 700;
            border-radius: 10px;
            padding: 12px;
            width: 100%;
            transition: 0.3s;
            text-transform: uppercase;
        }

        .btn-custom:hover {
            transform: scale(1.02);
            box-shadow: 0 0 15px rgba(56, 239, 125, 0.4);
        }

        /* Table Style */
        .table-custom { color: #fff; font-size: 14px; }
        .table-custom thead th { border: none; color: #38ef7d; text-transform: uppercase; font-size: 12px; }
        .table-custom td { border: none; vertical-align: middle; }
        .btn-delete { color: #ff4b2b; background: none; border: none; font-size: 18px; transition: 0.3s; }
        .btn-delete:hover { transform: scale(1.2); }

        .logo-img {
            border: 4px solid #38ef7d;
            border-radius: 50%;
            padding: 5px;
            box-shadow: 0 0 20px rgba(56, 239, 125, 0.3);
        }
    </style>
</head>
<body>

<div class="container">
    <div class="text-center mt-4">
        <img src="https://files.catbox.moe/6sd98j.jpg" class="logo-img" alt="Logo" width="100">
        <h4 class="mt-3 font-weight-bold text-uppercase">Panel By<span style="color:#38ef7d"> EagleBest</span></h4>
    </div>

    <div class="nav-contact">
        <a href="https://wa.me/6287784223102" target="_blank" class="btn-wa-nav">
            <i class="fab fa-whatsapp mr-2"></i> NO WHATSAPP YOSS LOMBOK
        </a>
    </div>

    <div class="glass-card">
        <div class="section-title">Data Server</div>
        <div class="form-group">
            <label>Nama Result</label>
            <input type="text" id="namaResult" class="form-control" value="<?= htmlspecialchars($nik); ?>">
        </div>
        <div class="form-group">
            <label>Panel Murni (Sender)</label>
            <input type="text" id="panelMurni" class="form-control" value="<?= htmlspecialchars($sender); ?>" readonly>
        </div>
        <button id="gantiButton" class="btn btn-custom mt-2">Update Data</button>
    </div>

    <div class="glass-card">
        <div class="section-title">Email Configuration</div>
        <div class="row">
            <div class="col-8">
                <input type="email" id="email" class="form-control" placeholder="Target Email...">
            </div>
            <div class="col-4">
                <input type="number" id="jumlahResult" class="form-control" value="1">
            </div>
        </div>
        <button id="addEmailButton" class="btn btn-custom mt-3">Add Receiver</button>

        <div class="table-responsive mt-4">
            <table class="table table-custom">
                <thead>
                    <tr>
                        <th>Email</th>
                        <th class="text-center">Limit</th>
                        <th class="text-center">Del</th>
                    </tr>
                </thead>
                <tbody id="emailData"></tbody>
            </table>
        </div>
    </div>

    <a href="https://whatsapp.com/channel/0029VbBfjDvHVvTimoAAuh04" target="_blank" class="btn-custom text-center d-block mt-4" style="text-decoration:none; background: linear-gradient(45deg, #00d2ff, #3a7bd5); color: #fff; box-shadow: 0 4px 15px rgba(0, 210, 255, 0.4);">
    <i class="fas fa-globe mr-2"></i> Create Panel Jasteb Klick disini
</a>

    <div class="text-center mt-4 text-muted" style="font-size: 11px;">
        &copy; <?= date('Y'); ?> Panel MangKezy - Secure Database System
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        fetchEmails();

        document.getElementById('gantiButton').addEventListener('click', function() {
            const namaResult = document.getElementById('namaResult').value;
            const panelMurni = document.getElementById('panelMurni').value;
            
            Swal.fire({
                title: 'Updating...',
                background: '#1a1a1a',
                didOpen: () => { Swal.showLoading() }
            });
            
            fetch(`ganti.php?nick=${encodeURIComponent(namaResult)}&sender=${encodeURIComponent(panelMurni)}`)
            .then(res => res.json())
            .then(data => {
                Swal.fire("Berhasil", data.message, "success").then(() => location.reload());
            });
        });

        document.getElementById('addEmailButton').addEventListener('click', function() {
            const email = document.getElementById('email').value;
            const limit = document.getElementById('jumlahResult').value;
            if(!email) return Swal.fire("Error", "Email kosong!", "error");

            const fd = new FormData();
            fd.append('email', email);
            fd.append('jumlahResult', limit);

            fetch('add.php', { method: 'POST', body: fd })
            .then(res => res.json())
            .then(() => { fetchEmails(); document.getElementById('email').value = ''; });
        });
    });

    function fetchEmails() {
        fetch('data.php').then(res => res.json()).then(data => {
            const body = document.getElementById('emailData');
            body.innerHTML = '';
            data.forEach(item => {
                body.innerHTML += `
                    <tr>
                        <td>${item.email}</td>
                        <td class="text-center"><span class="badge badge-success" style="background:#38ef7d;color:#000;">${item.jumlahResult}</span></td>
                        <td class="text-center">
                            <button class="btn-delete" onclick="deleteEmail('${item.email}')"><i class="fas fa-trash-alt"></i></button>
                        </td>
                    </tr>`;
            });
        });
    }

    function deleteEmail(email) {
        fetch('delete.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `email=${encodeURIComponent(email)}`
        }).then(() => fetchEmails());
    }
</script>

</body>
</html>
